# LinQini Backend - Laravel API

Backend Laravel pour la gestion des candidatures du programme Ingénieurs IT Tunisie-France.

## 🚀 Fonctionnalités

- ✅ API REST pour soumettre des candidatures
- ✅ Envoi automatique d'emails avec le CV en pièce jointe
- ✅ Interface d'administration pour gérer les candidatures
- ✅ Téléchargement des CV
- ✅ Marquage des candidatures comme lues
- ✅ Suppression des candidatures

## 📋 Prérequis

- PHP >= 8.2
- Composer
- SQLite (ou MySQL/PostgreSQL)

## 🔧 Installation

### 1. Installation des dépendances

```bash
composer install
```

### 2. Configuration de l'environnement

Le fichier `.env` est déjà configuré. Vous devez modifier les paramètres de mail :

```env
MAIL_MAILER=smtp
MAIL_HOST=smtp.gmail.com
MAIL_PORT=587
MAIL_USERNAME=yessinegargouri07@gmail.com
MAIL_PASSWORD=your_app_password_here
MAIL_ENCRYPTION=tls
```

**Important pour Gmail :**
1. Activez la vérification en 2 étapes
2. Générez un mot de passe d'application : https://myaccount.google.com/apppasswords
3. Remplacez `your_app_password_here` par le mot de passe généré

### 3. Exécuter les migrations

```bash
php artisan migrate
```

### 4. Créer le lien symbolique pour le storage

```bash
php artisan storage:link
```

### 5. Démarrer le serveur

```bash
php artisan serve
```

Le serveur sera accessible sur `http://localhost:8000`

## 📡 API Endpoints

### Candidatures

- **POST** `/api/candidatures` - Soumettre une candidature
- **GET** `/api/candidatures` - Lister toutes les candidatures
- **GET** `/api/candidatures/{id}` - Voir une candidature
- **PUT** `/api/candidatures/{id}/mark-as-read` - Marquer comme lue
- **DELETE** `/api/candidatures/{id}` - Supprimer une candidature
- **GET** `/api/candidatures/{id}/download-cv` - Télécharger le CV

### Interface Admin

- **GET** `/admin` - Dashboard des candidatures
- **GET** `/admin/candidature/{id}` - Détails d'une candidature

## 🎨 Interface Administrateur

Accédez à : `http://localhost:8000/admin`

### Fonctionnalités :
- 📊 Dashboard avec statistiques
- 📋 Liste de toutes les candidatures
- 👁️ Vue détaillée de chaque candidature
- 📥 Téléchargement des CV
- ✉️ Contact rapide (email, téléphone)
- 🗑️ Suppression des candidatures
- ✅ Marquage automatique comme "lue"

## 📧 Configuration Email

**Option 1 : Gmail** (recommandé)
- Activer la vérification en 2 étapes
- Générer un mot de passe d'application
- Configurer dans `.env`

**Option 2 : Log** (développement)
```env
MAIL_MAILER=log
```
Les emails seront dans `storage/logs/laravel.log`

## 📂 Structure de la base de données

### Table `candidatures`

| Colonne | Type | Description |
|---------|------|-------------|
| email | string | Email du candidat |
| full_name | string | Nom complet |
| phone | string | Téléphone / WhatsApp |
| availability | string | Disponibilité |
| education_level | string | Niveau d'études |
| experience_years | integer | Années d'expérience |
| speciality | string | Spécialité IT |
| career_wish | string | Souhait professionnel |
| expectations | text | Motivations |
| cv_path | string | Chemin du CV |
| rgpd_consent | boolean | Consentement RGPD |
| is_read | boolean | Candidature lue |

## 🔄 Frontend Angular

Le composant Angular est configuré pour communiquer avec cette API :

```typescript
private apiUrl = 'http://localhost:8000/api/candidatures';
```

## 📞 Support

Contact : yessinegargouri07@gmail.com

---

## About Laravel

Laravel is a web application framework with expressive, elegant syntax. We believe development must be an enjoyable and creative experience to be truly fulfilling. Laravel takes the pain out of development by easing common tasks used in many web projects, such as:

- [Simple, fast routing engine](https://laravel.com/docs/routing).
- [Powerful dependency injection container](https://laravel.com/docs/container).
- Multiple back-ends for [session](https://laravel.com/docs/session) and [cache](https://laravel.com/docs/cache) storage.
- Expressive, intuitive [database ORM](https://laravel.com/docs/eloquent).
- Database agnostic [schema migrations](https://laravel.com/docs/migrations).
- [Robust background job processing](https://laravel.com/docs/queues).
- [Real-time event broadcasting](https://laravel.com/docs/broadcasting).

Laravel is accessible, powerful, and provides tools required for large, robust applications.

## Learning Laravel

Laravel has the most extensive and thorough [documentation](https://laravel.com/docs) and video tutorial library of all modern web application frameworks, making it a breeze to get started with the framework. You can also check out [Laravel Learn](https://laravel.com/learn), where you will be guided through building a modern Laravel application.

If you don't feel like reading, [Laracasts](https://laracasts.com) can help. Laracasts contains thousands of video tutorials on a range of topics including Laravel, modern PHP, unit testing, and JavaScript. Boost your skills by digging into our comprehensive video library.

## Laravel Sponsors

We would like to extend our thanks to the following sponsors for funding Laravel development. If you are interested in becoming a sponsor, please visit the [Laravel Partners program](https://partners.laravel.com).

### Premium Partners

- **[Vehikl](https://vehikl.com)**
- **[Tighten Co.](https://tighten.co)**
- **[Kirschbaum Development Group](https://kirschbaumdevelopment.com)**
- **[64 Robots](https://64robots.com)**
- **[Curotec](https://www.curotec.com/services/technologies/laravel)**
- **[DevSquad](https://devsquad.com/hire-laravel-developers)**
- **[Redberry](https://redberry.international/laravel-development)**
- **[Active Logic](https://activelogic.com)**

## Contributing

Thank you for considering contributing to the Laravel framework! The contribution guide can be found in the [Laravel documentation](https://laravel.com/docs/contributions).

## Code of Conduct

In order to ensure that the Laravel community is welcoming to all, please review and abide by the [Code of Conduct](https://laravel.com/docs/contributions#code-of-conduct).

## Security Vulnerabilities

If you discover a security vulnerability within Laravel, please send an e-mail to Taylor Otwell via [taylor@laravel.com](mailto:taylor@laravel.com). All security vulnerabilities will be promptly addressed.

## License

The Laravel framework is open-sourced software licensed under the [MIT license](https://opensource.org/licenses/MIT).
