<?php

namespace App\Http\Controllers;

use App\Models\Candidature;
use Illuminate\Http\Request;

class AdminController extends Controller
{
    public function dashboard()
    {
        $candidatures = Candidature::orderBy('created_at', 'desc')->get();
        $stats = [
            'total' => Candidature::count(),
            'non_lues' => Candidature::where('is_read', false)->count(),
            'lues' => Candidature::where('is_read', true)->count(),
        ];
        
        return view('admin.dashboard', compact('candidatures', 'stats'));
    }

    public function show($id)
    {
        $candidature = Candidature::findOrFail($id);
        
        // Marquer comme lue automatiquement
        if (!$candidature->is_read) {
            $candidature->is_read = true;
            $candidature->save();
        }
        
        return view('admin.show', compact('candidature'));
    }
}
