<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Candidature extends Model
{
    use HasFactory;

    protected $fillable = [
        'email',
        'full_name',
        'phone',
        'availability',
        'education_level',
        'experience_years',
        'speciality',
        'career_wish',
        'expectations',
        'cv_path',
        'rgpd_consent',
        'is_read',
    ];

    protected $casts = [
        'rgpd_consent' => 'boolean',
        'is_read' => 'boolean',
        'experience_years' => 'integer',
    ];
}
