<?php

use App\Http\Controllers\CandidatureController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

// Routes pour les candidatures
Route::prefix('candidatures')->group(function () {
    Route::post('/', [CandidatureController::class, 'store']);
    Route::get('/', [CandidatureController::class, 'index']);
    Route::get('/{id}', [CandidatureController::class, 'show']);
    Route::put('/{id}/mark-as-read', [CandidatureController::class, 'markAsRead']);
    Route::delete('/{id}', [CandidatureController::class, 'destroy']);
    Route::get('/{id}/download-cv', [CandidatureController::class, 'downloadCv']);
});
