

<?php $__env->startSection('title', 'Dashboard - Candidatures'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <h1 class="text-white mb-4">
                <i class="fas fa-chart-line me-2"></i>Tableau de bord des candidatures
            </h1>
        </div>
    </div>

    <!-- Statistiques -->
    <div class="row mb-4">
        <div class="col-md-4">
            <div class="stat-card">
                <i class="fas fa-inbox fa-2x mb-3"></i>
                <h3><?php echo e($stats['total']); ?></h3>
                <p>Total des candidatures</p>
            </div>
        </div>
        <div class="col-md-4">
            <div class="stat-card" style="background: linear-gradient(135deg, #ff6b6b, #ee5a6f);">
                <i class="fas fa-envelope fa-2x mb-3"></i>
                <h3><?php echo e($stats['non_lues']); ?></h3>
                <p>Non lues</p>
            </div>
        </div>
        <div class="col-md-4">
            <div class="stat-card" style="background: linear-gradient(135deg, #4ecdc4, #44a08d);">
                <i class="fas fa-check-circle fa-2x mb-3"></i>
                <h3><?php echo e($stats['lues']); ?></h3>
                <p>Lues</p>
            </div>
        </div>
    </div>

    <!-- Liste des candidatures -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-gradient text-white" style="background: linear-gradient(135deg, var(--primary), var(--secondary));">
                    <h5 class="mb-0">
                        <i class="fas fa-list me-2"></i>Liste des candidatures
                    </h5>
                </div>
                <div class="card-body">
                    <?php if($candidatures->isEmpty()): ?>
                        <div class="text-center py-5">
                            <i class="fas fa-inbox fa-4x text-muted mb-3"></i>
                            <p class="text-muted">Aucune candidature pour le moment</p>
                        </div>
                    <?php else: ?>
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th width="50">Statut</th>
                                        <th>Nom</th>
                                        <th>Email</th>
                                        <th>Téléphone</th>
                                        <th>Spécialité</th>
                                        <th>Expérience</th>
                                        <th>Date</th>
                                        <th width="150">Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $candidatures; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $candidature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr onclick="window.location='<?php echo e(route('admin.candidature.show', $candidature->id)); ?>'" style="cursor: pointer;">
                                        <td>
                                            <?php if(!$candidature->is_read): ?>
                                                <span class="badge badge-unread">
                                                    <i class="fas fa-circle"></i>
                                                </span>
                                            <?php else: ?>
                                                <span class="badge bg-success">
                                                    <i class="fas fa-check"></i>
                                                </span>
                                            <?php endif; ?>
                                        </td>
                                        <td class="fw-bold"><?php echo e($candidature->full_name); ?></td>
                                        <td><?php echo e($candidature->email); ?></td>
                                        <td><?php echo e($candidature->phone); ?></td>
                                        <td>
                                            <span class="badge bg-primary"><?php echo e($candidature->speciality); ?></span>
                                        </td>
                                        <td><?php echo e($candidature->experience_years); ?> ans</td>
                                        <td><?php echo e($candidature->created_at->format('d/m/Y H:i')); ?></td>
                                        <td onclick="event.stopPropagation();">
                                            <a href="<?php echo e(route('admin.candidature.show', $candidature->id)); ?>" 
                                               class="btn btn-sm btn-primary" 
                                               title="Voir">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="<?php echo e(url('api/candidatures/' . $candidature->id . '/download-cv')); ?>" 
                                               class="btn btn-sm btn-success" 
                                               title="Télécharger CV"
                                               target="_blank">
                                                <i class="fas fa-download"></i>
                                            </a>
                                            <button class="btn btn-sm btn-danger delete-btn" 
                                                    data-id="<?php echo e($candidature->id); ?>"
                                                    title="Supprimer">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
$(document).ready(function() {
    $('.delete-btn').click(function(e) {
        e.preventDefault();
        e.stopPropagation();
        
        const id = $(this).data('id');
        
        if (confirm('Êtes-vous sûr de vouloir supprimer cette candidature ?')) {
            $.ajax({
                url: '/api/candidatures/' + id,
                type: 'DELETE',
                success: function(response) {
                    alert('Candidature supprimée avec succès');
                    location.reload();
                },
                error: function() {
                    alert('Erreur lors de la suppression');
                }
            });
        }
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\gstock\htdocs\Linkuni\linkini-back\resources\views/admin/dashboard.blade.php ENDPATH**/ ?>