<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Nouvelle Candidature</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
            background-color: #f4f4f4;
        }
        .container {
            background: white;
            border-radius: 10px;
            padding: 30px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .header {
            background: linear-gradient(135deg, #8a54ff, #548aff);
            color: white;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 30px;
            text-align: center;
        }
        .header h1 {
            margin: 0;
            font-size: 24px;
        }
        .section {
            margin-bottom: 25px;
            padding: 15px;
            border-left: 4px solid #8a54ff;
            background: #f9f9f9;
            border-radius: 4px;
        }
        .section-title {
            font-weight: bold;
            color: #8a54ff;
            font-size: 18px;
            margin-bottom: 10px;
        }
        .field {
            margin-bottom: 10px;
        }
        .field-label {
            font-weight: 600;
            color: #555;
        }
        .field-value {
            color: #333;
            margin-left: 10px;
        }
        .footer {
            text-align: center;
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #ddd;
            color: #777;
            font-size: 14px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>📧 Nouvelle Candidature Reçue</h1>
        </div>

        <div class="section">
            <div class="section-title">👤 Informations Personnelles</div>
            <div class="field">
                <span class="field-label">Nom complet:</span>
                <span class="field-value"><?php echo e($candidature->full_name); ?></span>
            </div>
            <div class="field">
                <span class="field-label">Email:</span>
                <span class="field-value"><?php echo e($candidature->email); ?></span>
            </div>
            <div class="field">
                <span class="field-label">Téléphone:</span>
                <span class="field-value"><?php echo e($candidature->phone); ?></span>
            </div>
            <div class="field">
                <span class="field-label">Disponibilité:</span>
                <span class="field-value"><?php echo e($candidature->availability); ?></span>
            </div>
        </div>

        <div class="section">
            <div class="section-title">🎓 Parcours Académique & Professionnel</div>
            <div class="field">
                <span class="field-label">Niveau d'études:</span>
                <span class="field-value"><?php echo e($candidature->education_level); ?></span>
            </div>
            <div class="field">
                <span class="field-label">Années d'expérience:</span>
                <span class="field-value"><?php echo e($candidature->experience_years); ?> ans</span>
            </div>
            <div class="field">
                <span class="field-label">Spécialité:</span>
                <span class="field-value"><?php echo e($candidature->speciality); ?></span>
            </div>
            <div class="field">
                <span class="field-label">Souhait professionnel:</span>
                <span class="field-value"><?php echo e($candidature->career_wish); ?></span>
            </div>
        </div>

        <div class="section">
            <div class="section-title">💡 Motivation & Attentes</div>
            <div class="field">
                <p style="margin: 0; white-space: pre-wrap;"><?php echo e($candidature->expectations); ?></p>
            </div>
        </div>

        <div class="section">
            <div class="section-title">📎 Documents</div>
            <div class="field">
                <span class="field-label">CV:</span>
                <span class="field-value">Voir pièce jointe</span>
            </div>
        </div>

        <div class="footer">
            <p>Cette candidature a été soumise le <?php echo e($candidature->created_at->format('d/m/Y à H:i')); ?></p>
            <p><strong>Programme Ingénieurs IT Tunisie-France</strong></p>
        </div>
    </div>
</body>
</html>
<?php /**PATH D:\xampp\gstock\htdocs\Linkuni\linkini-back\resources\views/emails/nouvelle-candidature.blade.php ENDPATH**/ ?>