

<?php $__env->startSection('title', 'Détails Candidature - ' . $candidature->full_name); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row mb-4">
        <div class="col-12">
            <a href="<?php echo e(route('admin.dashboard')); ?>" class="btn btn-light mb-3">
                <i class="fas fa-arrow-left me-2"></i>Retour au dashboard
            </a>
            <h1 class="text-white">
                <i class="fas fa-user-circle me-2"></i>Détails de la candidature
            </h1>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8">
            <!-- Informations personnelles -->
            <div class="card mb-4">
                <div class="card-header btn-gradient text-white">
                    <h5 class="mb-0"><i class="fas fa-user me-2"></i>Informations Personnelles</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="text-muted small">Nom complet</label>
                            <p class="fw-bold"><?php echo e($candidature->full_name); ?></p>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="text-muted small">Email</label>
                            <p class="fw-bold">
                                <a href="mailto:<?php echo e($candidature->email); ?>"><?php echo e($candidature->email); ?></a>
                            </p>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="text-muted small">Téléphone / WhatsApp</label>
                            <p class="fw-bold"><?php echo e($candidature->phone); ?></p>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="text-muted small">Disponibilité</label>
                            <p class="fw-bold"><?php echo e($candidature->availability); ?></p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Parcours académique -->
            <div class="card mb-4">
                <div class="card-header btn-gradient text-white">
                    <h5 class="mb-0"><i class="fas fa-graduation-cap me-2"></i>Parcours Académique & Professionnel</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="text-muted small">Niveau d'études</label>
                            <p class="fw-bold"><?php echo e(ucfirst($candidature->education_level)); ?></p>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="text-muted small">Années d'expérience</label>
                            <p class="fw-bold"><?php echo e($candidature->experience_years); ?> ans</p>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="text-muted small">Spécialité principale</label>
                            <p>
                                <span class="badge bg-primary p-2"><?php echo e($candidature->speciality); ?></span>
                            </p>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="text-muted small">Souhait professionnel</label>
                            <p class="fw-bold"><?php echo e($candidature->career_wish); ?></p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Motivation -->
            <div class="card mb-4">
                <div class="card-header btn-gradient text-white">
                    <h5 class="mb-0"><i class="fas fa-lightbulb me-2"></i>Motivation & Attentes</h5>
                </div>
                <div class="card-body">
                    <p style="white-space: pre-wrap;"><?php echo e($candidature->expectations); ?></p>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <!-- Statut -->
            <div class="card mb-4">
                <div class="card-header btn-gradient text-white">
                    <h5 class="mb-0"><i class="fas fa-info-circle me-2"></i>Statut</h5>
                </div>
                <div class="card-body text-center">
                    <?php if($candidature->is_read): ?>
                        <div class="alert alert-success">
                            <i class="fas fa-check-circle fa-2x mb-2"></i>
                            <p class="mb-0">Candidature lue</p>
                        </div>
                    <?php else: ?>
                        <div class="alert alert-warning">
                            <i class="fas fa-exclamation-circle fa-2x mb-2"></i>
                            <p class="mb-0">Non lue</p>
                        </div>
                    <?php endif; ?>
                    <small class="text-muted">
                        Reçue le <?php echo e($candidature->created_at->format('d/m/Y à H:i')); ?>

                    </small>
                </div>
            </div>

            <!-- CV -->
            <div class="card mb-4">
                <div class="card-header btn-gradient text-white">
                    <h5 class="mb-0"><i class="fas fa-file-pdf me-2"></i>Documents</h5>
                </div>
                <div class="card-body text-center">
                    <?php if($candidature->cv_path): ?>
                        <i class="fas fa-file-pdf fa-4x text-danger mb-3"></i>
                        <p class="mb-3">CV disponible</p>
                        <a href="<?php echo e(url('api/candidatures/' . $candidature->id . '/download-cv')); ?>" 
                           class="btn btn-success w-100"
                           target="_blank">
                            <i class="fas fa-download me-2"></i>Télécharger le CV
                        </a>
                    <?php else: ?>
                        <p class="text-muted">Aucun CV disponible</p>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Actions -->
            <div class="card">
                <div class="card-header btn-gradient text-white">
                    <h5 class="mb-0"><i class="fas fa-cog me-2"></i>Actions</h5>
                </div>
                <div class="card-body">
                    <a href="mailto:<?php echo e($candidature->email); ?>" class="btn btn-primary w-100 mb-2">
                        <i class="fas fa-envelope me-2"></i>Envoyer un email
                    </a>
                    <a href="tel:<?php echo e($candidature->phone); ?>" class="btn btn-success w-100 mb-2">
                        <i class="fas fa-phone me-2"></i>Appeler
                    </a>
                    <button class="btn btn-danger w-100 delete-btn" data-id="<?php echo e($candidature->id); ?>">
                        <i class="fas fa-trash me-2"></i>Supprimer
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
$(document).ready(function() {
    $('.delete-btn').click(function() {
        const id = $(this).data('id');
        
        if (confirm('Êtes-vous sûr de vouloir supprimer cette candidature ?')) {
            $.ajax({
                url: '/api/candidatures/' + id,
                type: 'DELETE',
                success: function(response) {
                    alert('Candidature supprimée avec succès');
                    window.location.href = '<?php echo e(route("admin.dashboard")); ?>';
                },
                error: function() {
                    alert('Erreur lors de la suppression');
                }
            });
        }
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\gstock\htdocs\Linkuni\linkini-back\resources\views/admin/show.blade.php ENDPATH**/ ?>